/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.util;

import com.aptana.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTUtils {
    private static final String SMALL_FONT = "com.aptana.ui.small_font";
    private static Color backgroundErrorColor;
    private static Color errorColor;
    private static ModifyListener modifyListener;

    static {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ColorRegistry cm = JFaceResources.getColorRegistry();
                RGB errorRGB = new RGB(255, 255, 180);
                cm.put("error", errorRGB);
                backgroundErrorColor = cm.get("error");
            }
        });
        errorColor = UIUtils.getDisplay().getSystemColor(3);
    }

    public static void centerAndPack(Shell shell, Shell parent) {
        shell.pack();
        SWTUtils.center(shell, parent);
    }

    public static void center(Shell shell, Shell parent) {
        Rectangle parentSize = parent.getBounds();
        Rectangle mySize = shell.getBounds();
        int locationX = (parentSize.width - mySize.width) / 2 + parentSize.x;
        int locationY = (parentSize.height - mySize.height) / 2 + parentSize.y;
        shell.setLocation(new Point(locationX, locationY));
    }

    public static Font getDefaultSmallFont() {
        Font small = JFaceResources.getFontRegistry().get(SMALL_FONT);
        if (small != null) {
            return small;
        }
        Font f = JFaceResources.getDefaultFont();
        FontData[] smaller = SWTUtils.resizeFont(f, -2);
        JFaceResources.getFontRegistry().put(SMALL_FONT, smaller);
        return JFaceResources.getFontRegistry().get(SMALL_FONT);
    }

    public static Image getImage(AbstractUIPlugin plugin, String path) {
        return SWTUtils.getImage(plugin.getBundle(), path);
    }

    public static Image getImage(AbstractUIPlugin plugin, String path, ImageDescriptor descriptor) {
        return SWTUtils.getImage(plugin.getBundle(), path, descriptor);
    }

    public static Image getImage(IPath computedPath) {
        String bundleSymbolicName = computedPath.segment(0);
        String iconPath = computedPath.removeFirstSegments(1).toOSString();
        return SWTUtils.getImage(bundleSymbolicName, iconPath);
    }

    public static Image getImage(Bundle bundle, String path) {
        return SWTUtils.getImage(bundle, path, null);
    }

    private static Image getImage(Bundle bundle, String path, ImageDescriptor id) {
        if (path.charAt(0) != '/') {
            path = "/" + path;
        }
        return SWTUtils.getImage(bundle.getSymbolicName(), path, id);
    }

    private static Image getImage(String bundleSymbolicName, String path) {
        return SWTUtils.getImage(bundleSymbolicName, path, null);
    }

    private static Image getImage(String bundleSymbolicName, String path, ImageDescriptor id) {
        String computedName = String.valueOf(bundleSymbolicName) + path;
        Image image = JFaceResources.getImage((String)computedName);
        if (image != null) {
            return image;
        }
        if (id == null) {
            id = AbstractUIPlugin.imageDescriptorFromPlugin((String)bundleSymbolicName, (String)path);
        }
        if (id != null) {
            JFaceResources.getImageRegistry().put(computedName, id);
            return JFaceResources.getImage((String)computedName);
        }
        return null;
    }

    public static Image scaleImage(Image image, double maxWidth, double maxHeight) throws Exception {
        ImageData imageData = image.getImageData();
        if ((double)imageData.width > maxWidth || (double)imageData.height > maxHeight) {
            double scaleX = maxWidth / (double)imageData.width;
            double scaleY = maxHeight / (double)imageData.height;
            double scale = Math.min(scaleX, scaleY);
            imageData = imageData.scaledTo((int)Math.round((double)imageData.width * scale), (int)Math.round((double)imageData.height * scale));
            image.dispose();
            image = new Image((Device)UIUtils.getDisplay(), imageData);
        }
        return image;
    }

    public static void disposeImage(Image image) {
        if (image != null && !image.isDisposed()) {
            image.dispose();
        }
    }

    public static void disposeControl(Control control) {
        if (control != null && !control.isDisposed()) {
            control.dispose();
        }
    }

    public static boolean isControlDisposed(Control control) {
        return control != null ? control.isDisposed() : true;
    }

    public static FontData[] resizeFont(Font font, int size) {
        FontData[] datas;
        FontData[] fontDataArray = datas = font.getFontData();
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setHeight(data.getHeight() + size);
            ++n2;
        }
        return datas;
    }

    public static FontData[] resizeFont(FontData[] fontData, int size) {
        FontData[] fontDataArray = fontData;
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setHeight(data.getHeight() + size);
            ++n2;
        }
        return fontData;
    }

    public static FontData[] boldFont(Font font) {
        return SWTUtils.styleFont(font, 1);
    }

    public static FontData[] styleFont(Font font, int fontStyle) {
        FontData[] datas;
        FontData[] fontDataArray = datas = font.getFontData();
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(data.getStyle() | fontStyle);
            ++n2;
        }
        return datas;
    }

    public static FontData[] italicizedFont(Font font) {
        return SWTUtils.styleFont(font, 2);
    }

    public static Color getErrorColor() {
        return errorColor;
    }

    public static boolean validateCombo(Combo combo, int validSelectionIndex) {
        int selectionIndex = Math.max(validSelectionIndex, 0);
        String text = combo.getText();
        if (text == null || text.length() == 0 || combo.getSelectionIndex() < selectionIndex) {
            combo.setBackground(backgroundErrorColor);
            return false;
        }
        combo.setBackground(null);
        return true;
    }

    public static boolean testWidgetValue(Text widget) {
        if (widget.getText() == null || "".equals(widget.getText())) {
            widget.setBackground(backgroundErrorColor);
            if (modifyListener == null) {
                modifyListener = new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text t = (Text)e.widget;
                        if (t.getText() != null && !"".equals(t.getText())) {
                            t.setBackground(null);
                        } else {
                            t.setBackground(backgroundErrorColor);
                        }
                    }
                };
                widget.addModifyListener(modifyListener);
            }
            return false;
        }
        return true;
    }

    public static void resizeControlWidthInGrid(Collection<Control> controls) {
        SWTUtils.resizeControlSizeInGrid(controls, false, true);
    }

    public static void resizeControlHeightInGrid(Collection<Control> controls) {
        SWTUtils.resizeControlSizeInGrid(controls, true, false);
    }

    private static void resizeControlSizeInGrid(Collection<Control> controls, boolean resizeHeight, boolean resizeWidth) {
        int largestHeight = -1;
        int largestWidth = -1;
        ArrayList<GridData> gridDatas = new ArrayList<GridData>();
        for (Control control : controls) {
            Object layoutData = control.getLayoutData();
            if (!(layoutData instanceof GridData)) continue;
            GridData gridData = (GridData)layoutData;
            gridDatas.add(gridData);
            if (resizeHeight && gridData.heightHint > largestHeight) {
                largestHeight = gridData.heightHint;
                continue;
            }
            if (resizeWidth && gridData.widthHint > largestWidth) {
                largestWidth = gridData.widthHint;
                continue;
            }
            Point preferredSize = control.computeSize(-1, -1);
            if (resizeHeight) {
                if (preferredSize.y <= largestHeight) continue;
                largestHeight = preferredSize.y;
                continue;
            }
            if (!resizeWidth || preferredSize.x <= largestWidth) continue;
            largestWidth = preferredSize.x;
        }
        for (GridData gridData : gridDatas) {
            if (resizeHeight) {
                gridData.heightHint = largestHeight;
                continue;
            }
            if (!resizeWidth) continue;
            gridData.widthHint = largestWidth;
        }
    }

    public static void updateErrorLabelWidth(Label label, Font errorFont) {
        Object layoutData = label.getLayoutData();
        if (layoutData instanceof GridData) {
            Font currentFont = label.getFont();
            label.setFont(errorFont);
            ((GridData)layoutData).widthHint = label.computeSize((int)-1, (int)-1).x;
            label.setFont(currentFont);
        }
    }

    public static void updateLabelStatus(Label label, Font errorFont, Color errorColor, boolean isValid) {
        label.setForeground(isValid ? null : errorColor);
        label.setFont(isValid ? null : errorFont);
    }

    public static void setVisiblity(Control control, boolean visible) {
        if (control == null) {
            return;
        }
        control.setVisible(visible);
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).exclude = !visible;
        }
    }
}

